#ifndef __MT_M3GM_VIEWER_H__
#define __MT_M3GM_VIEWER_H__

#include "MTSimpleResource.h"
#include "MTGrafPortWindow.h"
#include "MTPNTAViewer.h"
#include "MTIDXAViewer.h"
#include "MTTXCAViewer.h"
#include "MTTXMPViewer.h"

#include <agl.h>

class MTM3GMViewer : public MTSimpleResourceHandler, public MTGrafPortWindow
{
	public:
				MTM3GMViewer();
				~MTM3GMViewer();
		
		void	PostProcess(void);
		void	GetWindowName(StringPtr theString)	{ pstrcpy(theString, "\pM3GM 3D Viewer"); }
		
		void	RecieveMessage(UInt32 messageType, UInt32 messageData);
		UInt8	SupportsMessage(UInt32 messageType, UInt32 messageData);
		
		void	HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers);
	
	protected:
		MTSimpleResourceTemplate *	GetDataTemplate(void)	{ return &kM3GMFormatTemplate; }
	
	private:
		static MTSimpleResourceTemplate	kM3GMFormatTemplate;
		
		void	GetPortSize(UInt32 * inWidth, UInt32 * inHeight)	{ *inWidth = 300; *inHeight = 300; }
		UInt32	GetPortDepth(void)									{ return 32; }
		void	DrawToPort(GWorldPtr theWorld);
		
		void	LoadTexture(UInt32 id);
		void	UnloadTexture(void);
		
		MTPNTAViewer	* pnta;
		MTIDXAViewer	* idxa;
		MTTXCAViewer	* txca;
		MTTXMPHandler	txmp;
		
		UInt8			* textureData;
		GLuint			textureID;
		UInt32			txmpID;
		
		float			rotX, rotY, rotZ;
		float			traX, traY, traZ;
		float			scale;
		SInt32			idxOffset;
		UInt8			useWireframe;
		
		UInt8			txmpIsGood;
};

#endif /* __MT_M3GM_VIEWER_H__ */